<?php

/*
+---------------------------------------------------------------------------+
| OpenX v2.4                                                                |
| ==========                                                                |
|                                                                           |
| Copyright (c) 2003-2008 OpenX Limited                                     |
| For contact details, see: http://www.openx.org/                           |
|                                                                           |
| This program is free software; you can redistribute it and/or modify      |
| it under the terms of the GNU General Public License as published by      |
| the Free Software Foundation; either version 2 of the License, or         |
| (at your option) any later version.                                       |
|                                                                           |
| This program is distributed in the hope that it will be useful,           |
| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
| GNU General Public License for more details.                              |
|                                                                           |
| You should have received a copy of the GNU General Public License         |
| along with this program; if not, write to the Free Software               |
| Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA |
+---------------------------------------------------------------------------+
$Id: banner-acl.php 16122 2008-02-11 18:15:10Z andrew.hill@openads.org $
*/

// Require the initialisation file
require_once '../../init.php';

// Required files
require_once MAX_PATH . '/lib/OA/Dal.php';
require_once MAX_PATH . '/www/admin/config.php';
require_once MAX_PATH . '/www/admin/lib-statistics.inc.php';
require_once MAX_PATH . '/lib/max/other/html.php';
require_once MAX_PATH . '/lib/max/Plugin.php';
require_once MAX_PATH . '/lib/max/other/lib-acl.inc.php';
require_once MAX_PATH . '/lib/max/Delivery/cache.php';
require_once MAX_PATH . '/lib/max/other/capping/lib-capping.inc.php';

// Register input variables
phpAds_registerGlobal ('acl', 'action', 'submit');

/*-------------------------------------------------------*/
/* Client interface security                             */
/*-------------------------------------------------------*/
MAX_Permission::checkAccess(phpAds_Admin + phpAds_Agency);

// Initialise some parameters
$pageName = basename($_SERVER['PHP_SELF']);
$tabindex = 1;
$agencyId = phpAds_getAgencyID();
$aEntities = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $bannerid);

if (!MAX_checkAd($clientid, $campaignid, $bannerid)) {
    phpAds_Die($strAccessDenied, $strNotAdmin);
}

if (!empty($action)) {
    $acl = MAX_AclAdjust($acl, $action);
} elseif (!empty($submit)) {
    $aBannerPrev = MAX_cacheGetAd($bannerid, false);
    $acl = (isset($acl)) ? $acl : array();
    MAX_AclSave($acl, $aEntities);

    _initCappingVariables();

    $values = array();
    $acls_updated = false;
    $now = OA::getNow();

    if ($aBannerPrev['block_ad'] <> $block) {
        $values['block'] = $block;
        $acls_updated = ($block == 0) ? true : $acls_updated;
    }
    if ($aBannerPrev['cap_ad'] <> $cap) {
        $values['capping'] = $cap;
        $acls_updated = ($cap == 0) ? true : $acls_updated;
    }
    if ($aBannerPrev['session_cap_ad'] <> $session_capping) {
        $values['session_capping'] = $session_capping;
        $acls_updated = ($session_capping == 0) ? true : $acls_updated;
    }
    if ($acls_updated) {
        $values['acls_updated'] = $now;
    }

    if (!empty($values)) {
        $values['updated'] = $now;
        $doBanners = OA_Dal::factoryDO('banners');
        $doBanners->get($bannerid);
        $doBanners->setFrom($values);
        $doBanners->update();
    }

    header("Location: banner-zone.php?clientid={$clientid}&campaignid={$campaignid}&bannerid={$bannerid}");
    exit;
}

/*-------------------------------------------------------*/
/* HTML framework                                        */
/*-------------------------------------------------------*/

// Display navigation
$aOtherCampaigns = Admin_DA::getPlacements(array('agency_id' => $agencyId));
$aOtherBanners = Admin_DA::getAds(array('placement_id' => $campaignid), false);
MAX_displayNavigationBanner($pageName, $aOtherCampaigns, $aOtherBanners, $aEntities);

/*-------------------------------------------------------*/
/* Main code                                             */
/*-------------------------------------------------------*/

$aBanner = MAX_cacheGetAd($bannerid, false);

if (isset($acl)) {
    $acl = MAX_aclAStripslashed($acl);
} else {
    $acl = Admin_DA::getDeliveryLimitations(array('ad_id' => $bannerid));
    // This array needs to be sorted by executionorder, this should ideally be done in SQL
    // When we move to DataObject this should be addressed
    ksort($acl);
}

$aParams = array('clientid' => $clientid, 'campaignid' => $campaignid, 'bannerid' => $bannerid);

MAX_displayAcls($acl, $aParams);

echo "
<table border='0' width='100%' cellpadding='0' cellspacing='0' bgcolor='#FFFFFF'>";

$aParams = array(
    'title' => $GLOBALS['strCampaign'],
    'titleLink' => "campaign-edit.php?clientid=$clientid&campaignid=$campaignid",
    'aText' => $GLOBALS['strCappingCampaign'],
    'aCappedObject' => $aBanner,
    'type' => 'Campaign'
);

$tabindex = _echoDeliveryCappingHtml($tabindex, $GLOBALS['strCappingBanner'], $aBanner, 'Ad', $aParams);

echo "
<tr><td height='1' colspan='6' bgcolor='#888888'>
<img src='images/break.gif' height='1' width='100%'></td></tr>

</table>
<br /><br /><br />
<input type='submit' name='submit' value='{$GLOBALS['strSaveChanges']}' tabindex='".($tabindex++)."'>

</form>";


/*-------------------------------------------------------*/
/* Form requirements                                     */
/*-------------------------------------------------------*/
?>
<?php

_echoDeliveryCappingJs();

phpAds_PageFooter();

?>
